//
//  YHAppointHKResultModel.swift
//  galaxy
//
//  Created by edy on 2024/8/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHAppointHKResultModel: SmartCodable {
    
    var waiting: [YHAppointMemberGroupModel] = []
    var success: [YHAppointMemberGroupModel] = []

    enum CodingKeys: String, CodingKey {
        case waiting = "waiting"
        case success = "success"
    }
    
    required init() {
        
    }

    init(waiting: [YHAppointMemberGroupModel], success: [YHAppointMemberGroupModel]) {
        self.waiting = waiting
        self.success = success
    }
}

class YHAppointMemberGroupModel: SmartCodable {
    var id: Int = 0
    var orderid: Int = 0
    var userList: [YHAppointMemberModel] = []
    var wantMinTime: String = ""
    var wantMaxTime: String = ""
    var immigrationOffice: String = ""
    var wantImmigrationOffice: String = ""
    var goTime: String = ""
    // 此处是私链URL数组
    var receipts: [String] = []
    var submitTime: String = ""
    var isWillVisitHkGalaxyBay: Int = 0  // 0没有选择1是2否

    // 自定义
    // 私链反馈回执对应的公链
    var publicReceipts: [String] = []
    
    // 公链数组中是否有空链
    func hasEmptyPublicReceipte() -> Bool {
        let filterArr =  publicReceipts.filter {
            return $0.isEmpty
        }
        return filterArr.count > 0
    }

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case orderid = "order_id"
        case userList = "user_list"
        case wantMinTime = "want_min_time"
        case wantMaxTime = "want_max_time"
        case immigrationOffice = "immigration_office"
        case wantImmigrationOffice = "want_immigration_office"
        case goTime = "go_time"
        case receipts = "receipts"
        case submitTime = "submit_time"
        case isWillVisitHkGalaxyBay = "is_will_visit_hk_galaxy_bay"
    }
    
    required init() {
        
    }

    init(id: Int, orderid: Int, userList: [YHAppointMemberModel], wantMinTime: String, wantMaxTime: String, immigrationOffice: String, wantImmigrationOffice: String, goTime: String, receipts: [String], submitTime: String) {
        self.id = id
        self.orderid = orderid
        self.userList = userList
        self.wantMinTime = wantMinTime
        self.wantMaxTime = wantMaxTime
        self.immigrationOffice = immigrationOffice
        self.wantImmigrationOffice = wantImmigrationOffice
        self.goTime = goTime
        self.receipts = receipts
        self.submitTime = submitTime
    }
    
    func getMemberNames() -> String {
        var text = ""
        for (index, user) in self.userList.enumerated() {
            text += user.name
            if index != self.userList.count-1 {
                text += "、"
            }
        }
        return text
    }
}

// MARK: - UserList
class YHAppointMemberModel: SmartCodable {
    
    var id: Int = 0
    var name: String = ""
    var type: String = ""
    var fileNum: String = ""
    var birthday: String = ""
    var isCheck: Int = 0
    var url: String = ""
    var approvalDate: String = ""
    var relation: String = ""

    enum CodingKeys: String, CodingKey {
        case id = "id"
        case name = "name"
        case type = "type"
        case fileNum = "file_num"
        case birthday = "birthday"
        case isCheck = "is_check"
        case url = "url"
        case approvalDate = "approval_date"
        case relation = "relation"
    }
    
    required init() {
        
    }

    init(id: Int, name: String, type: String, fileNum: String, birthday: String, isCheck: Int, url: String, approvalDate: String, relation: String) {
        self.id = id
        self.name = name
        self.type = type
        self.fileNum = fileNum
        self.birthday = birthday
        self.isCheck = isCheck
        self.url = url
        self.approvalDate = approvalDate
        self.relation = relation
    }
}
